﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Newtonsoft.Json;
using Ext.Net;
using System.IO;
using System.Data;
using DataAccess;
using System.Collections;
using System.Web.Script.Serialization;
using System.Xml;

//setup an alias for all direct method calls on this control
[DirectMethodProxyID(IDMode = DirectMethodProxyIDMode.Alias, Alias = "UCPLAN")]

public partial class ucPlan : System.Web.UI.UserControl
{
    public BaseMaster BaseMstr { get; set; }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7003 US:7002 US:7001 User clicked the plan save button
    /// </summary>
    protected void OnPlanOK(object sender, DirectEventArgs e)
    {
        //event title must be at least 1 chars dont have to have a title!
        //  if (tfEPWEventTitle.Text.Length < 1)
        //  {
        //      BaseMstr.ShowSystemFeedback("Please enter a valid event title!", "Data Entry Error");
        //      return -1;
        //  }

        ////must have a date selected
        //DateTime dtSchedule = dfPLNEventDate.SelectedDate;
        //if (dtSchedule.Year <= 1)
        //{
        //    BaseMstr.ShowSystemFeedback("Please select a valid date!", "Data Entry Error");
        //    return;
        //}

        //plan must have text
        //if (tfPLAN.Text.Length <= 1)
        //{
        //    BaseMstr.ShowSystemFeedback("Please enter valid plan text!", "Data Entry Error");
        //    return;
        //}

        //objects needed below
        CCPA cpa = new CCPA();
        CPWEvent evt = new CPWEvent();
        
        //if no event, we need to create one
        if (CDataUtils2.ToLong(NextPatPWEventID) < 1)
        {
            //create a new event
            long lID = evt.InsertPWEvent(BaseMstr,
                                          BaseMstr.RegionID,
                                          BaseMstr.SiteID,
                                          BaseMstr.SelectedPatientID,
                                          CDataUtils2.ToLong(PatPWID),
                                          tfPLNEventTitle.Text,
                                          dfPLNEventDate.SelectedDate,
                                          CDataUtils2.ToLong(PatPWEventID));


            //set NextPatPWEventID = the event we jsut created
            NextPatPWEventID = Convert.ToString(lID);

            //everything below should now work...
        }

        //JSON representation
        string gpJSON = e.ExtraParams["gpSelPLNParam"];

        //XML representation
        XmlNode gpXml = JSON.DeserializeXmlNode("{records:{record:" + gpJSON + "}}");

        //array of Dictionaries
        Dictionary<string, string>[] gpData = JSON.Deserialize<Dictionary<string, string>[]>(gpJSON);

        //all selected modules much have module for set
        for (int i = 0; i < gpData.Count(); i++)
        {
            if (String.IsNullOrEmpty(gpData[i]["MODULE_FOR"]))
            {
                BaseMstr.ShowSystemFeedback("Please choose who the instrument is for: patient, provider or both for all selected instruments!", "Data Entry Error");
                return;
            }
        }

        //get mid and module_for values
        string strFors = String.Empty;
        string strMids = String.Empty;
        for (int i = 0; i < gpData.Count(); i++)
        {
            strFors += gpData[i]["MODULE_FOR"];
            if (i != gpData.Count() - 1)
            {
                strFors += ",";
            }

            strMids += gpData[i]["MID"];
            if (i != gpData.Count() - 1)
            {
                strMids += ",";
            }
        }

        //should we adjust future dates?
        long lAdjustFuture = 0;
        if (chkPLNAdjustFuture.Checked)
        {
            lAdjustFuture = 1;
        }

        //update event info and the list of modules. 
        //this will remove all current modules and replace with 
        //only the selected modules...
        cpa.UpdatePWEventModules(BaseMstr,
                                 BaseMstr.SelectedPatientID,
                                 CDataUtils2.ToLong(NextPatPWEventID),
                                 tfPLNEventTitle.Text,
                                 dfPLNEventDate.SelectedDate,
                                 lAdjustFuture,
                                 strMids,
                                 strFors);

        //update the plan event
        evt.UpdatePWEventPlan(BaseMstr,
                              CDataUtils2.ToLong(PatPWEventID),
                              CDataUtils2.ToLong(NextPatPWEventID),
                              tfPLAN.Text);

    }
   
    /// <summary>
    ///US:7002 event entry id
    /// </summary>
    public string PatPWEventID
    {
        get
        {
            string strValue = "";
            if (Session["UCPLANPatPWEventID"] != null)
            {
                strValue = Session["UCPLANPatPWEventID"].ToString();
            }

            return strValue;
        }
        set { Session["UCPLANPatPWEventID"] = Convert.ToString(value); }
    }

    /// <summary>
    ///US:7002 patient pathway id
    /// </summary>
    public string PatPWID
    {
        get
        {
            string strValue = "";
            if (Session["UCPLANPatPWID"] != null)
            {
                strValue = Session["UCPLANPatPWID"].ToString();
            }

            return strValue;
        }
        set { Session["UCPLANPatPWID"] = Convert.ToString(value); }
    }

    /// <summary>
    ///US:7002 next patient pathway id
    /// </summary>
    public string NextPatPWEventID
    {
        get
        {
            string strValue = "";
            if (Session["UCPLANNextPatPWEventID"] != null)
            {
                strValue = Session["UCPLANNextPatPWEventID"].ToString();
            }

            return strValue;
        }
        set { Session["UCPLANNextPatPWEventID"] = Convert.ToString(value); }
    }

    /// <summary>
    /// US:7002 selected instrument ids
    /// </summary>
    public string SelectedMIDS
    {
        get
        {
            string strValue = "";
            if (Session["UCPINSTRUMENTSEL_MIDS"] != null)
            {
                strValue = Session["UCPINSTRUMENTSEL_MIDS"].ToString();
            }

            return strValue;
        }
        set { Session["UCPINSTRUMENTSEL_MIDS"] = Convert.ToString(value); }
    }
    
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7005 Close the instrument selection popup
    /// </summary>
    /// <param name="strPatPWEventID"></param>
    /// <returns></returns>
    public void OnCloseInstrumentSel()
    {
        //wndPLNSelInstruments.Close();    
    }


    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", SuccessFn="fnReloadEventsNodes")]
    /// <summary>
    ///US:7002 Reload events after save
    /// </summary>
    /// <param name="strPatPWEventID"></param>
    /// <returns></returns>
    public long ReloadPWEventNodes()
    {
        return CDataUtils2.ToLong(NextPatPWEventID);
    }



    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7005 US:7002 US:7001 Initialize the control
    /// </summary>
    /// <param name="strPatPWEventID"></param>
    /// <returns></returns>
    public bool InitializeControl(string strPatPWEventID)
    {
        //don't reload the if already loaded
        if (strPatPWEventID == PatPWEventID)
        {
            return true;
        }

        //keep the patient pathway event id
        PatPWEventID = strPatPWEventID;

        return InitializeControl(CDataUtils2.ToLong(PatPWEventID));       
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7005 US:7002 US:7001 Initialize the control
    /// </summary>
    /// <param name="strPatPWEventID"></param>
    /// <returns></returns>
    public bool InitializeControl2(string strPatPWEventID)
    {
        //keep the patient pathway event id
        PatPWEventID = strPatPWEventID;

        return InitializeControl(CDataUtils2.ToLong(PatPWEventID));
    }

    public bool InitializeControl(long lPatPWEventID)
    {
         //start enabled
        btnUCPlanSave.Enable();
        cboPLNTemplate.Enable();
        tfPLAN.ReadOnly = false;
        tfPLNEventTitle.ReadOnly = false;
        dfPLNEventDate.ReadOnly = false;
        chkPLNAdjustFuture.Enable();
        
        btnUCPlanAddInstr.Enable();
        btnUCPlanDelInstr.Enable();

        //create a objects to do work
        CPWEvent evt = new CPWEvent();
        CCPA cpa = new CCPA();
                
        //get the plan text
        DataSet dsEvt = cpa.GetPatPWEventByIDDS(BaseMstr,
                                                BaseMstr.SelectedPatientID,
                                               lPatPWEventID);


        //disable if this event is closed
        long lStatus = CDataUtils2.GetDSLongValue(dsEvt, "STATUS");
        if (lStatus == 2)
        {
            btnUCPlanSave.Disable();
            cboPLNTemplate.Disable();
            tfPLAN.ReadOnly = true;
            tfPLNEventTitle.ReadOnly = true;
            dfPLNEventDate.ReadOnly = true;
            chkPLNAdjustFuture.Disable();
            
            btnUCPlanAddInstr.Disable();
            btnUCPlanDelInstr.Disable();
        }

        //data entry is encoded before going to the database
        //therefore we have to decode it before loading it into a control
        tfPLAN.Text = HttpUtility.HtmlDecode(CDataUtils2.GetDSStringValue(dsEvt, "PLAN_TEXT"));

        //get the patient pathway id
        PatPWID = CDataUtils2.GetDSStringValue(dsEvt, "PAT_PW_ID");

        //get the pw event id for this plan, if not there get the next on
        long lNextPatPWID = CDataUtils2.GetDSLongValue(dsEvt, "PLAN_PAT_PW_EVENT_ID");
        if (lNextPatPWID < 1)
        {
            //get the patient pathway event id for the event that falls AFTER strPatPWEventID
            DataSet dsNext = evt.GetNextPatPWEventDS(BaseMstr,
                                                     BaseMstr.SelectedPatientID,
                                                     lPatPWEventID);

            lNextPatPWID = CDataUtils2.GetDSLongValue(dsNext, "PAT_PW_EVENT_ID");
        }
        
        NextPatPWEventID = Convert.ToString(lNextPatPWID);
                
        //clear selected mids
        SelectedMIDS = String.Empty;

       
        //load the selected instruments from the current list of modules
        //clear the selected instruments
        gpPLNSelInstruments.GetStore().RemoveAll();
        gpPLNSelInstruments.Items.Clear();
        storPLNSelInstruments.SetDataFromJson(CDataUtils2.GetEmptyJSON());

        DataSet dsModules = cpa.GetPatPWEventModuleDS(BaseMstr,
                                                      BaseMstr.SelectedPatientID,
                                                      lNextPatPWID);

        //remove records from the dataset that are completed
        foreach (DataTable table in dsModules.Tables)
        {
            foreach (DataRow row in table.Rows)
            {
                if (CDataUtils2.GetDSLongValue(row, "intake_id") > 0)
                {
                    row.Delete();
                }
            }
        }
        dsModules.AcceptChanges();
        string strMIDS = "";
        foreach (DataTable dt in dsModules.Tables)
        {
            foreach (DataRow dr in dt.Rows)
            {
                //get instrument info
                string strMID = CDataUtils2.GetDSStringValue(dr, "MID");
                string strModule = CDataUtils2.GetDSStringValue(dr, "MODULE");
                string strDescription = CDataUtils2.GetDSStringValue(dr, "DESCRIPTION");

                //cache the selected mid
                strMIDS += "," + strMID + ",";
                strMIDS = strMIDS.Replace(",,", ",");
                SelectedMIDS = strMIDS;

                CDataConverter cdc = new CDataConverter();
                string strJsonRecord = cdc.GetJsonDRString(dr);

                //add instrument to second list 
                //turn the json record passed to us into and object
                JavaScriptSerializer serializer = new JavaScriptSerializer();
                Dictionary<string, object> ds = serializer.Deserialize<Dictionary<string, object>>(strJsonRecord);

                //add the object to the grid's store
                storPLNSelInstruments.Add(ds);

                //split mids from cache to work with, only include mids 
                //that are not from the currently selected group
                RowSelectionModel sm1 = gpPLNSelInstruments.GetSelectionModel() as RowSelectionModel;
                if (sm1 != null)
                {
                    sm1.SelectedRows.Add(new SelectedRow(strMID));

                    //if you change selected rows in a 
                    //direct method you must call update selection!
                    sm1.UpdateSelection();
                }
            }
        }

        //load the event title and date
        DataSet dsEvent = cpa.GetPatPWEventByIDDS(BaseMstr, 
                                                  BaseMstr.SelectedPatientID,
                                                  lNextPatPWID);
        
        //event title
        tfPLNEventTitle.Text = CDataUtils2.GetDSStringValue(dsEvent, "EVENT_TITLE");

        //date
        dfPLNEventDate.SelectedDate = CDataUtils2.GetDSDateTimeValue(dsEvent, "DATE_SCHEDULED");
             
        return true;
    }

  
  

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7005 User checked an instrument from the instrument selection popup
    /// </summary>
    public void OnInstrumentSel(string strJsonRecord)
    {

        //get instrument info
        string strMID = CDataUtils2.GetJsonRecordValue("MID", strJsonRecord);
        string strModule = CDataUtils2.GetJsonRecordValue("MODULE", strJsonRecord);
        string strDescription = CDataUtils2.GetJsonRecordValue("DESCRIPTION", strJsonRecord);

        //cache the selected mid
        string strMIDS = SelectedMIDS;
        //only add if its not already in the list
        if (strMIDS.IndexOf("," + strMID + ",") != -1)
        {
            return;
        }
        strMIDS += "," + strMID + ",";
        strMIDS = strMIDS.Replace(",,", ",");
        SelectedMIDS = strMIDS;


        //add instrument to second list 
        //turn the json record passed to us into and object
        JavaScriptSerializer serializer = new JavaScriptSerializer();
        Dictionary<string, object> ds = serializer.Deserialize<Dictionary<string, object>>(strJsonRecord);

        if (ds != null)
        {
            //add the object to the grid's store
            storPLNSelInstruments.Add(ds);
        }

        //split mids from cache to work with, only include mids 
        //that are not from the currently selected group
        RowSelectionModel sm = gpPLNSelInstruments.GetSelectionModel() as RowSelectionModel;
        if (sm != null)
        {
            sm.SelectedRows.Add(new SelectedRow(strMID));

            //if you change selected rows in a 
            //direct method you must call update selection!
            sm.UpdateSelection();
        }


    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7005 user unchecked an instrument from the instrument selection popup
    /// </summary>
    public void OnInstrumentDeSel(string strJsonRecord)
    {

        //get instrument info
        string strMID = CDataUtils2.GetJsonRecordValue("MID", strJsonRecord);
        string strModule = CDataUtils2.GetJsonRecordValue("MODULE", strJsonRecord);
        string strDescription = CDataUtils2.GetJsonRecordValue("DESCRIPTION", strJsonRecord);

        //remove instrument from second list

        //turn the json record passed to us into and object
        JavaScriptSerializer serializer = new JavaScriptSerializer();
        Dictionary<string, object> ds = serializer.Deserialize<Dictionary<string, object>>(strJsonRecord);

        //remove the item from the grid
        storPLNSelInstruments.Remove(ds["MID"]);

        //remove the selected mid from the cache
        string strMIDS = SelectedMIDS;
        strMIDS = strMIDS.Replace("," + strMID + ",", ",,");
        strMIDS = strMIDS.Replace(",,", ",");
        SelectedMIDS = strMIDS;

    }
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7005  user clicked the select instrument button
    /// </summary>
    public void OnSelectInstruments()
    {
        ShowInstrumentSelPopup();
    }


    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7002 user unchecked an instrument
    /// </summary>
    public void OnRemoveInstrument()
    {
        RowSelectionModel sm = gpPLNSelInstruments.GetSelectionModel() as RowSelectionModel;
        if (sm != null)
        {
            if (sm.SelectedRow == null)
            {
                BaseMstr.ShowSystemFeedback("Please select an instrument to remove!", "Selection Error");
                return;
            }


            string strJsonRecord = "{\"MID\":" + sm.SelectedRow.RecordID + "}";

            //turn the json record passed to us into and object
            JavaScriptSerializer serializer = new JavaScriptSerializer();
            Dictionary<string, object> ds = serializer.Deserialize<Dictionary<string, object>>(strJsonRecord);

            //remove the item from the grid
            storPLNSelInstruments.Remove(ds["MID"]);

            //remove the selected mid from the cache
            string strMIDS = SelectedMIDS;
            strMIDS = strMIDS.Replace("," + sm.SelectedRow.RecordID + ",", ",,");
            strMIDS = strMIDS.Replace(",,", ",");
            SelectedMIDS = strMIDS;

            //LoadInstruments();
        }
    }

    /// <summary>
    /// US:7003 US:7002 US:7005 US:7001 page load, initialize control
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            PatPWEventID = "";

            //load the templates
            CTemplate tmpl = new CTemplate();
            DataSet dsTemplates = tmpl.GetTemplateDS(BaseMstr, CTemplate.TemplateTypeID.ASSESSMENT_PLAN);
            //clear the combo
            cboPLNTemplate.GetStore().RemoveAll();
            cboPLNTemplate.Items.Clear();
            //load the store from the ds
            CDataConverter cdc = new CDataConverter();
            string strTemplatesJSON = cdc.GetJsonDSString(dsTemplates);
            storePLNTemplates.SetDataFromJson(strTemplatesJSON);

            //clear 
            tfPLAN.Text = "";
            tfPLNEventTitle.Text = "";
            
        }
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7001 Load template selected
    /// </summary>
    /// <param name="strTemplateID"></param>
    public void LoadPlanTemplate(string strTemplateID)
    {
        CTemplate template = new CTemplate();

        if (!String.IsNullOrEmpty(strTemplateID) && !strTemplateID.Equals("null"))
        {
            string strParsedTemplate = template.GetParsedTemplateText2(BaseMstr,
                                                                       BaseMstr.SelectedPatientID,
                                                                       PatPWEventID,
                                                                       Convert.ToInt32(strTemplateID));
            tfPLAN.Text += strParsedTemplate;
            cboPLNTemplate.SelectedItems.Clear();
            cboPLNTemplate.UpdateSelectedItems();
        }
    }









    
        /// <summary>
        /// US:7440 get comma delimeted list of instruments already added to this event
        /// </summary>
        /// <returns></returns>
        protected string GetEventMIDS()
        {
            CCPA cpa = new CCPA();

            //get all modules already added to this event and not completed
            string strEventMIDS = ",";
            DataSet dsEventMID = cpa.GetPWEventModuleDS(BaseMstr, CDataUtils2.ToLong(PatPWEventID));
            if (dsEventMID != null)
            {
                foreach (DataTable tbl in dsEventMID.Tables)
                {
                    foreach (DataRow rw in tbl.Rows)
                    {
                        if (CDataUtils2.GetDSLongValue(rw, "INTAKE_ID") < 1) //not completed
                        {
                            strEventMIDS += CDataUtils2.GetDSStringValue(rw, "MID");
                            strEventMIDS += ",";
                        }
                    }
                }
            }

            return strEventMIDS;
        }

        [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
        /// <summary>
        ///US:7440  user searched for instruments
        /// </summary>
        public void OnSearch()
        {
            string strSearch = tfPLANEITSearch.Text;
            //if (strSearch.Length < 3)
            //{
            //    BaseMstr.ShowSystemFeedback("Search must be at least 3 characters!", "Search Error");
            //    return;
            //}

            DataSet dsMID = null;

            if (rdoPLANEITCPA.Checked || rdoPLANEITDisp.Checked)
            {
                string strGroupID = cboPLANInstrumentGroup.SelectedItem.Value;

                CIntake intake = new CIntake();
                dsMID = intake.GetModuleGroupMIDDS(BaseMstr,
                                                   Convert.ToInt64(strGroupID),
                                                   strSearch);
            }
            else
            {
                CCPA cpa = new CCPA();
                dsMID = cpa.GetModuleSearchDS(BaseMstr,
                                                      strSearch);
            }

            if (CDataUtils2.IsEmpty(dsMID))
            {
                BaseMstr.ShowSystemFeedback("No matches found!", "Search Error");
                return;
            }

            //get all modules already added to this event
            string strEventMIDS = SelectedMIDS;// GetEventMIDS();

            foreach (DataTable table in dsMID.Tables)
            {
                foreach (DataRow row in table.Rows)
                {
                    string strMIDCheck = "," + CDataUtils2.GetDSStringValue(row, "MID") + ",";
                    if (strEventMIDS.IndexOf(strMIDCheck) > -1)
                    {
                        //remove mids that are already part of the event
                        row.Delete();
                    }
                    else
                    {
                        //module data is not encoded in the db...
                        row["MODULE"] = HttpUtility.HtmlEncode(row["MODULE"].ToString());
                        row["DESCRIPTION"] = HttpUtility.HtmlEncode(row["DESCRIPTION"].ToString());
                        row["MODULE_ALT_LANG"] = HttpUtility.HtmlEncode(row["MODULE_ALT_LANG"].ToString());
                    }
                }
            }
            dsMID.AcceptChanges();

            //clear the store
            storPLANInstruments.SetDataFromJson(CDataUtils2.GetEmptyJSON());

            //load the store from the ds
            CDataConverter cdc = new CDataConverter();
            storPLANInstruments.SetDataFromJson(cdc.GetJsonDSString(dsMID));

        }

        /// <summary>
        /// US:7440 load instruments gridpanel by group id
        /// </summary>
        protected void LoadInstruments(string strGroupID)
        {
            //get the modules ds
            CIntake im = new CIntake();
            DataSet dsMID = im.GetModuleGroupMIDDS(BaseMstr, CDataUtils2.ToLong(strGroupID));

            //get all modules already added to this event
            string strEventMIDS = SelectedMIDS;//GetEventMIDS();

            if (CDataUtils2.IsEmpty(dsMID))
            {
                return;
            }
            foreach (DataTable table in dsMID.Tables)
            {
                foreach (DataRow row in table.Rows)
                {
                    string strMIDCheck = "," + CDataUtils2.GetDSStringValue(row, "MID") + ",";
                    if (strEventMIDS.IndexOf(strMIDCheck) > -1)
                    {
                        //remove mids that are already part of the event
                        row.Delete();
                    }
                    else
                    {
                        //module data is not encoded in the db...
                        row["MODULE"] = HttpUtility.HtmlEncode(row["MODULE"].ToString());
                        row["DESCRIPTION"] = HttpUtility.HtmlEncode(row["DESCRIPTION"].ToString());
                        row["MODULE_ALT_LANG"] = HttpUtility.HtmlEncode(row["MODULE_ALT_LANG"].ToString());
                    }
                }
            }
            dsMID.AcceptChanges();

            //clear the store
            storPLANInstruments.SetDataFromJson(CDataUtils2.GetEmptyJSON());

            //load the store from the ds
            CDataConverter cdc = new CDataConverter();
            storPLANInstruments.SetDataFromJson(cdc.GetJsonDSString(dsMID));
        }


        [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
        /// <summary>
        ///US:7440 fires when a group is selected from the combo
        /// </summary>
        public void OnGroupSelect()
        {
            //clear the store
            storPLANInstruments.SetDataFromJson(CDataUtils2.GetEmptyJSON());
            if (cboPLANInstrumentGroup.SelectedItem == null)
            {
                return;
            }

            //get the group id from the combo
            string strGroupID = cboPLANInstrumentGroup.SelectedItem.Value;

            //enable search
            EnableSearch();

            //load the instruments for this group
            LoadInstruments(strGroupID);
        }

        [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
        /// <summary>
        ///US:7440  load the instrument grid based on the combo group type
        /// </summary>
        /// <param name="strGroupTypeID"></param>
        public void OnGroupTypeSelect()
        {
            //clear the instruments
            gpPLANInstruments.GetStore().RemoveAll();
            storPLANInstruments.SetDataFromJson(CDataUtils2.GetEmptyJSON());

            if (rdoPLANEITCPA.Checked)
            {
                DisableSearch();
                cboPLANInstrumentGroup.Show();
                this.LoadInstrumentGroups(1000);
            }
            else if (rdoPLANEITDisp.Checked)
            {
                DisableSearch();
                cboPLANInstrumentGroup.Show();
                this.LoadInstrumentGroups(2000);
            }
            else
            {
                if (rdoPLANEITAll.Checked == false)
                {
                    rdoPLANEITAll.Checked = true;
                }

                EnableSearch();
                //this.LoadInstrumentGroups(-1);

                //clear value
                cboPLANInstrumentGroup.SetValue(null);
                //clear the store
                storPLANModuleGroups.SetDataFromJson(CDataUtils2.GetEmptyJSON());
                cboPLANInstrumentGroup.Hide();

                //now just load all the modules
                CCPA cpa = new CCPA();
                DataSet dsMID = cpa.GetAllModuleDS(BaseMstr);

                //get all modules already added to this event
                string strEventMIDS = SelectedMIDS;// GetEventMIDS();

                foreach (DataTable table in dsMID.Tables)
                {
                    foreach (DataRow row in table.Rows)
                    {
                        string strMIDCheck = "," + CDataUtils2.GetDSStringValue(row, "MID") + ",";
                        if (strEventMIDS.IndexOf(strMIDCheck) > -1)
                        {
                            //remove mids that are already part of the event
                            row.Delete();
                        }
                        else
                        {
                            //module data is not encoded in the db...
                            row["MODULE"] = HttpUtility.HtmlEncode(row["MODULE"].ToString());
                            row["DESCRIPTION"] = HttpUtility.HtmlEncode(row["DESCRIPTION"].ToString());
                            row["MODULE_ALT_LANG"] = HttpUtility.HtmlEncode(row["MODULE_ALT_LANG"].ToString());
                        }
                    }
                }
                dsMID.AcceptChanges();

                //clear the store
                storPLANInstruments.SetDataFromJson(CDataUtils2.GetEmptyJSON());

                //load the store from the ds
                CDataConverter cdc = new CDataConverter();
                storPLANInstruments.SetDataFromJson(cdc.GetJsonDSString(dsMID));

            }
        }

        /// <summary>
        /// US: 7356 Disable Search controls
        /// </summary>
        private void DisableSearch()
        {
            tfPLANEITSearch.Clear();
            tfPLANEITSearch.ClearInvalid();
            tfPLANEITSearch.Disabled = true;
            btnPlanSearch.Disabled = true;
        }

        /// <summary>
        /// US: 7356 Enable Search controls
        /// </summary>
        private void EnableSearch()
        {
            tfPLANEITSearch.Disabled = false;
            btnPlanSearch.Disabled = false;
        }

        /// <summary>
        ///US:7440 load instrument groups into the combo
        /// </summary>
        /// <param name="lGroupTypeID"></param>
        public void LoadInstrumentGroups(long lGroupTypeID)
        {
            //clear value
            cboPLANInstrumentGroup.SetValue(null);

            //clear the store
            storPLANModuleGroups.SetDataFromJson(CDataUtils2.GetEmptyJSON());

            //get the group types ds
            CIntake im = new CIntake();
            DataSet dsModuleGroup = im.GetModuleGroupDS(BaseMstr, lGroupTypeID);
            if (CDataUtils2.IsEmpty(dsModuleGroup))
            {
                return;
            }

            //load the store from the ds
            CDataConverter cdc = new CDataConverter();
            storPLANModuleGroups.SetDataFromJson(cdc.GetJsonDSString(dsModuleGroup));
        }

        /// <summary>
        /// US:7440 show the intrument add popup
        /// </summary>
        public void ShowInstrumentSelPopup()
        {
            //default to ALL 
            rdoPLANEITCPA.Checked = false;   //1000 = Clinical Program Area
            rdoPLANEITDisp.Checked = false; //2000 = Disiplines
            rdoPLANEITAll.Checked = true;  //-1 = All

            //load the combo with cpa options
            this.LoadInstrumentGroups(1000);

            //clear the combo selection
            cboPLANInstrumentGroup.ClearValue();

            //clear the instruments
            gpPLANInstruments.GetStore().RemoveAll();
            storPLANInstruments.SetDataFromJson(CDataUtils2.GetEmptyJSON());

            //show the window
            wndPLANAddInstrument.Show();
            wndPLANAddInstrument.Center();

            //start with ALL instruments loaded
            OnGroupTypeSelect();
        }

        [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
        /// <summary>
        ///US:7440 ok button handler for instrument add popup
        /// </summary>
        protected void OnInstrSelOK(object sender, DirectEventArgs e)
        {
            //JSON representation
            string gpJSON = e.ExtraParams["gpSelParam"];
            gpJSON = HttpUtility.HtmlDecode(gpJSON);

            //XML representation
            XmlNode gpXml = JSON.DeserializeXmlNode("{records:{record:" + gpJSON + "}}");

            //array of Dictionaries
            Dictionary<string, object>[] gpData = JSON.Deserialize<Dictionary<string, object>[]>(gpJSON);

            if (gpData != null)
            {
                //add the object to the grid's store
                storPLNSelInstruments.Add(gpData);
            }

            //get mid and module_for values
            string strFors = String.Empty;
            string strMids = String.Empty;
            for (int i = 0; i < gpData.Count(); i++)
            {
                strFors += gpData[i]["MODULE_FOR"];
                if (i != gpData.Count() - 1)
                {
                    strFors += ",";
                }

                strMids += gpData[i]["MID"];
                if (i != gpData.Count() - 1)
                {
                    strMids += ",";
                }
            }

            //UPDATE CACHE SELECTED LIST
            string strMIDS = SelectedMIDS;
            //only add if its not already in the list
            for (int i = 0; i < gpData.Count(); i++)
            {
                if (strMIDS.IndexOf("," + gpData[i]["MID"] + ",") == -1)
                {
                    strMIDS += "," + gpData[i]["MID"] + ",";
                    strMIDS = strMIDS.Replace(",,", ",");
                    SelectedMIDS = strMIDS;
                }
            }
            

            //update event info and the list of modules. 
            //this will remove all current modules and replace with 
            //only the selected modules...
    //        CCPA cpa = new CCPA();
      //      cpa.InsertPatPWEventModules(BaseMstr,
        //                                BaseMstr.SelectedPatientID,
          //                              CDataUtils2.ToLong(PatPWEventID),
            //                            strMids,
              //                          strFors);


            //close the add instrument popup
            wndPLANAddInstrument.Close();
        }

}